<?php
require_once dirname(__DIR__) . '/config/env.php';
require_once dirname(__DIR__) . '/autoload.php';
session_start();

$di = require dirname(__DIR__) . '/bootstrap.php';
$adminModel = $di['admin'];

$fallbackPass = getenv('ADMIN_PASSWORD') ?: 'admin123';

if (isset($_SESSION['admin_logged']) && $_SESSION['admin_logged']) {
    header('Location: /admin/');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    $admin = $adminModel->verifyPassword($username, $password);
    if ($admin) {
        $_SESSION['admin_logged'] = true;
        $_SESSION['admin_id'] = $admin['id'];
        $_SESSION['admin_username'] = $admin['username'];
        $adminModel->updateLastLogin((int) $admin['id']);
        header('Location: /admin/');
        exit;
    }
    if (empty($username) && $password === $fallbackPass) {
        $_SESSION['admin_logged'] = true;
        header('Location: /admin/');
        exit;
    }
    $error = 'Invalid username or password.';
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Login</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background: #0f172a; min-height: 100vh; display: flex; align-items: center; justify-content: center; color: #f1f5f9; }
        .card { background: #111827; border: 1px solid #334155; border-radius: 0.75rem; }
        .btn-success { background: #22c55e; border-color: #22c55e; }
    </style>
</head>
<body>
    <div class="card p-4" style="width: 320px;">
        <h4 class="mb-3">Admin Login</h4>
        <?php if (!empty($error)): ?><div class="alert alert-danger py-2"><?= htmlspecialchars($error) ?></div><?php endif; ?>
        <form method="post">
            <div class="mb-2">
                <label class="form-label">Username</label>
                <input type="text" name="username" class="form-control bg-dark text-white border-secondary" value="<?= htmlspecialchars($_POST['username'] ?? '') ?>" required autofocus>
            </div>
            <div class="mb-3">
                <label class="form-label">Password</label>
                <input type="password" name="password" class="form-control bg-dark text-white border-secondary" required>
            </div>
            <button type="submit" class="btn btn-success w-100">Login</button>
        </form>
    </div>
</body>
</html>
