<?php

declare(strict_types=1);

$db = require __DIR__ . '/database.php';

$dsn = sprintf(
    '%s:host=%s;port=%d;dbname=%s;charset=%s',
    $db['driver'],
    $db['host'],
    $db['port'],
    $db['database'],
    $db['charset']
);

try {
    $pdo = new PDO($dsn, $db['username'], $db['password'], [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
} catch (PDOException $e) {
    throw new RuntimeException('Database connection failed: ' . $e->getMessage());
}

return $pdo;
