<?php

declare(strict_types=1);

require_once dirname(__DIR__) . '/config/env.php';
require_once dirname(__DIR__) . '/autoload.php';

$pdo = require dirname(__DIR__) . '/config/connection.php';
$retryModel = new \App\Models\CallbackRetry($pdo);
$http = new \App\Services\HttpService();

$pending = $retryModel->getPending(20);

foreach ($pending as $item) {
    $payload = json_decode($item['payload'], true);
    if (!is_array($payload)) continue;

    $result = $http->postJson($item['callback_url'], $payload);

    if ($result['success'] ?? false) {
        $retryModel->delete((int) $item['id']);
    } else {
        $retryModel->markAttempted((int) $item['id'], $result['error'] ?? 'Unknown error');
    }
}

echo "Processed " . count($pending) . " callbacks.\n";
