<?php

declare(strict_types=1);

namespace App\Middleware;

class CheckWhitelist
{
    public function checkIp(?array $allowedIps, string $clientIp): bool
    {
        if ($allowedIps === null || empty($allowedIps)) {
            return true;
        }
        return in_array($clientIp, $allowedIps, true);
    }

    public function checkDomain(?array $allowedDomains, ?string $originOrReferer): bool
    {
        if ($allowedDomains === null || empty($allowedDomains)) {
            return true;
        }
        if (empty($originOrReferer)) {
            return true;
        }
        $parsed = parse_url($originOrReferer);
        $host = $parsed['host'] ?? null;
        if (!$host) {
            return false;
        }
        foreach ($allowedDomains as $domain) {
            $domain = strtolower(trim($domain));
            if ($domain === $host || str_ends_with($host, '.' . $domain)) {
                return true;
            }
        }
        return false;
    }

    public function __invoke(array $client, string $clientIp, ?string $originOrReferer = null): bool
    {
        if (!$this->checkIp($client['allowed_ips'] ?? null, $clientIp)) {
            return false;
        }
        if (!$this->checkDomain($client['allowed_domains'] ?? null, $originOrReferer)) {
            return false;
        }
        return true;
    }
}
