<?php

declare(strict_types=1);

namespace App\Middleware;

use App\Services\HttpService;

class SendRequest
{
    public function __construct(
        private HttpService $http,
        private string $baseUrl,
        private string $token
    ) {}

    public function __invoke(string $encryptedPayload): array
    {
        $url = $this->baseUrl . '?payload=' . urlencode($encryptedPayload) . '&token=' . urlencode($this->token);
        return $this->http->get($url);
    }
}
