<?php

declare(strict_types=1);

namespace App\Models;

use PDO;

class GameSession
{
    public function __construct(
        private PDO $pdo
    ) {}

    public function create(int $clientId, string $userId, string $gameUid, ?string $sessionId = null, ?string $callbackUrl = null, ?string $returnUrl = null): void
    {
        $stmt = $this->pdo->prepare('
            INSERT INTO game_sessions (client_id, user_id, game_uid, session_id, callback_url, return_url)
            VALUES (?, ?, ?, ?, ?, ?)
        ');
        $stmt->execute([$clientId, $userId, $gameUid, $sessionId, $callbackUrl, $returnUrl]);
    }

    public function findByGameUid(string $gameUid): ?array
    {
        $stmt = $this->pdo->prepare('
            SELECT gs.*, c.callback_url as client_callback_url, c.return_url as client_return_url
            FROM game_sessions gs
            JOIN clients c ON c.id = gs.client_id
            WHERE gs.game_uid = ?
        ');
        $stmt->execute([$gameUid]);
        return $stmt->fetch() ?: null;
    }
}
