<?php

declare(strict_types=1);

header('Content-Type: application/json; charset=utf-8');
header('X-Content-Type-Options: nosniff');
date_default_timezone_set('Asia/Kolkata');

$baseDir = dirname(__DIR__);
$di = require $baseDir . '/bootstrap.php';

$method = $_SERVER['REQUEST_METHOD'] ?? 'GET';
$path = parse_url($_SERVER['REQUEST_URI'] ?? '/', PHP_URL_PATH);
$path = rtrim($path, '/') ?: '/';

$clientIp = $_SERVER['HTTP_X_FORWARDED_FOR'] ?? $_SERVER['HTTP_X_REAL_IP'] ?? $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
if (strpos($clientIp, ',') !== false) {
    $clientIp = trim(explode(',', $clientIp)[0]);
}
$origin = $_SERVER['HTTP_ORIGIN'] ?? $_SERVER['HTTP_REFERER'] ?? null;

function jsonResponse(array $data, int $code = 200): void
{
    http_response_code($code);
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
}

switch ($path) {
    case '/api/launch-game':
        if ($method !== 'GET' && $method !== 'POST') {
            jsonResponse(['code' => 405, 'msg' => 'Method not allowed'], 405);
            exit;
        }
        $input = $method === 'POST' ? (json_decode(file_get_contents('php://input'), true) ?? []) : $_GET;
        if (empty($input) && $method === 'POST') {
            $input = $_POST;
        }
        $result = $di['launch']->handle($input, $clientIp, $origin);
        $httpCode = $result['code'] ?? 200;
        if ($httpCode >= 400) {
            jsonResponse($result, $httpCode);
        } else {
            jsonResponse($result, 200);
        }
        break;

    case '/api/callback':
        if ($method !== 'POST') {
            jsonResponse(['credit_amount' => -1, 'error' => 'Method not allowed'], 405);
            exit;
        }
        $rawInput = file_get_contents('php://input') ?: '{}';
        $result = $di['callback']->handle($rawInput, $clientIp);
        jsonResponse($result, 200);
        break;

    default:
        jsonResponse(['code' => 404, 'msg' => 'Not found'], 404);
}
